local GTR = {}

GTR.Options = {
    ReqElecLvl   = 0,
    ConvertToRT  = false
}

local PZOptions

local config = {
    ReqElecLvl   = nil,
    ConvertToRT  = nil,
}

local function applyOptions()
    local options = PZAPI.ModOptions:getOptions("GeneratorTimeRemaining")

    if options then
        GTR.Options.ReqElecLvl  = options:getOption("ReqElecLvl"):getValue()
        GTR.Options.ConvertToRT = options:getOption("ConvertToRT"):getValue()
    else
        print("GTR: Could not load saved settings.  Using defaults.")
    end
end

local function initConfig()
    PZOptions = PZAPI.ModOptions:create("GeneratorTimeRemaining", getText("UI_GTR_Options_Title"))

    config.ReqElecLvl = PZOptions:addSlider(
        "ReqElecLvl",
        getText("UI_GTR_Options_ReqLevel"),
        0,
        10,
        1,
        GTR.Options.ReqElecLvl,
        getText("UI_GTR_Options_ReqLevel_Tooltip")
    )

    config.ConvertToRT = PZOptions:addTickBox(
        "ConvertToRT",
        getText("UI_GTR_Options_Convert"),
        GTR.Options.ConvertToRT,
        getText("UI_GTR_Options_Convert_Tooltip")
    )

    PZOptions.apply = function ()
        applyOptions()
    end
end

initConfig()

Events.OnMainMenuEnter.Add(function()
    applyOptions()
end)

return GTR